<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\SiswaModel;

class Siswa extends BaseController
{
    protected $siswaModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
    }

    /**
     * Halaman Galeri Siswa (Frontend)
     */
    public function index()
    {
        $data = [
            'title' => 'Siswa & Siswi',
            'siswaItems' => $this->siswaModel
                ->orderBy('kelas_angka', 'DESC') // XII → XI → X
                ->orderBy('kelas_sub', 'ASC')    // .1 → .2
                ->orderBy('nama', 'ASC')         // A–Z
                ->findAll(),
        ];

        // ganti view sesuai struktur frontend kamu
        return view('frontend/siswa', $data);
    }
}
